/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.raoulvdberge.refinedstorage.api.util.IStackList;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class StackListFluid
implements IStackList<FluidStack> {
    private final Map<FluidStackWrapper, StackListEntry<FluidStack>> stacks = new ConcurrentHashMap<FluidStackWrapper, StackListEntry<FluidStack>>();
    private final Map<UUID, StackListEntry<FluidStack>> index = new HashMap<UUID, StackListEntry<FluidStack>>();
    private long stored;

    @Override
    public StackListResult<FluidStack> add(@Nonnull FluidStack stack, long size) {
        if (size <= 0L) {
            throw new IllegalArgumentException("Cannot accept empty stack");
        }
        FluidStackWrapper wrapper = new FluidStackWrapper(stack);
        StackListEntry<FluidStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            FluidStack otherStack = entry.getStack();
            entry.grow(size);
            this.stored += size;
            return new StackListResult<FluidStack>(otherStack.copy(), entry.getId(), size);
        }
        FluidStack newStack = stack.copy();
        wrapper.setStack(newStack);
        StackListEntry<FluidStack> newEntry = new StackListEntry<FluidStack>(newStack, size);
        this.stacks.put(wrapper, newEntry);
        this.index.put(newEntry.getId(), newEntry);
        this.stored += size;
        return new StackListResult<FluidStack>(newStack.copy(), newEntry.getId(), size);
    }

    @Override
    public StackListResult<FluidStack> add(@Nonnull FluidStack stack) {
        return this.add(stack, (long)stack.amount);
    }

    @Override
    public StackListResult<FluidStack> remove(@Nonnull FluidStack stack, long size) {
        FluidStackWrapper wrapper = new FluidStackWrapper(stack);
        StackListEntry<FluidStack> entry = this.stacks.get(wrapper);
        if (entry != null) {
            FluidStack otherStack = entry.getStack();
            if (entry.getCount() - size <= 0L) {
                this.stacks.remove(wrapper, entry);
                this.index.remove(entry.getId());
                this.stored -= entry.getCount();
                return new StackListResult<FluidStack>(otherStack.copy(), entry.getId(), -entry.getCount());
            }
            entry.shrink(size);
            this.stored -= size;
            return new StackListResult<FluidStack>(otherStack.copy(), entry.getId(), -size);
        }
        return null;
    }

    @Override
    public StackListResult<FluidStack> remove(@Nonnull FluidStack stack) {
        return this.remove(stack, (long)stack.amount);
    }

    @Override
    @Nullable
    public StackListEntry<FluidStack> getEntry(@Nonnull FluidStack stack, int flags) {
        StackListEntry<FluidStack> entry = this.stacks.get(new FluidStackWrapper(stack));
        return entry != null ? entry.asUnmodifiable() : null;
    }

    @Override
    @Nullable
    public FluidStack get(@Nonnull FluidStack stack, int flags) {
        StackListEntry<FluidStack> entry = this.getEntry(stack, flags);
        if (entry == null) {
            return null;
        }
        FluidStack copy = entry.getStack().copy();
        copy.amount = (int)Math.min(entry.getCount(), Integer.MAX_VALUE);
        return copy;
    }

    @Override
    @Nullable
    public StackListEntry<FluidStack> get(UUID id) {
        StackListEntry<FluidStack> entry = this.index.get(id);
        if (entry == null) {
            return null;
        }
        return entry.asUnmodifiable();
    }

    @Override
    public void clear() {
        this.stacks.clear();
        this.index.clear();
        this.stored = 0L;
    }

    @Override
    public void clearCounts() {
        for (StackListEntry<FluidStack> entry : this.stacks.values()) {
            entry.setCount(0L);
        }
        this.stored = 0L;
    }

    @Override
    public void clearEmpty() {
        Iterator<Map.Entry<FluidStackWrapper, StackListEntry<FluidStack>>> iterator = this.stacks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FluidStackWrapper, StackListEntry<FluidStack>> entry = iterator.next();
            if (entry.getValue().getCount() >= 1L) continue;
            iterator.remove();
            this.index.remove(entry.getValue().getId());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    @Override
    @Nonnull
    public Collection<StackListEntry<FluidStack>> getStacks() {
        return this.stacks.values();
    }

    @Override
    public long getStored() {
        return this.stored;
    }

    @Override
    @Nonnull
    public IStackList<FluidStack> copy() {
        StackListFluid list = new StackListFluid();
        for (StackListEntry<FluidStack> entry : this.stacks.values()) {
            StackListEntry<FluidStack> newEntry = new StackListEntry<FluidStack>(entry.getId(), entry.getStack().copy(), entry.getCount());
            list.stacks.put(new FluidStackWrapper(entry.getStack()), newEntry);
            list.index.put(entry.getId(), newEntry);
            list.stored += newEntry.getCount();
        }
        return list;
    }

    public static final class FluidStackWrapper {
        private final int hashCode;
        private FluidStack fluidStack;

        public FluidStackWrapper(FluidStack template) {
            this.fluidStack = template;
            boolean isEmpty = template.amount < 1;
            Fluid fluid = template.getFluid();
            NBTTagCompound originalNbt = template.tag;
            NBTTagCompound nbt = originalNbt == null ? null : originalNbt.func_74737_b();
            int hashCode1 = 31 + Boolean.hashCode(isEmpty);
            hashCode1 = 31 * hashCode1 + fluid.hashCode();
            hashCode1 = 31 * hashCode1 + (nbt == null ? 0 : nbt.hashCode());
            this.hashCode = hashCode1 = 31 * hashCode1 + template.hashCode();
        }

        public void setStack(FluidStack fluidStack) {
            this.fluidStack = fluidStack;
        }

        public FluidStack getStack() {
            return this.fluidStack;
        }

        public boolean equals(Object o) {
            return API.instance().getComparer().isEqual(this.fluidStack, ((FluidStackWrapper)o).fluidStack, 2);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

